/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCecInterfaceImplLimits;
import com.ibm.hsc.fsp.cmdhelpers.FspFileInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;

public class FspFileOpCmds {
    private static FspFileOpCmds mInst = null;
    private static final String READ_FILE = "READ_FILE";
    private static final String WRITE_FILE = "WRITE_FILE";
    private static final String CLOSE_FILE = "CLOSE_FILE";
    private static final String DATA = "DATA";
    private static final String LENGTH_WRITTEN = "LENGTH_WRITTEN";
    private static final String ACKNOWLEDGE_PLATFORM_DUMP = "ACKNOWLEDGE_PLATFORM_DUMP";
    public static final String MOUNT_PARTITION = "/dump";
    public static final String DUMP_FILE_SEPERATOR = "/";
    public static final String DUMP_ENTRY_HEADER = "FILE";
    public static final String PLATFORM_DUMP_DIR = "/";
    public static final String FSP_DUMP_DIR = "/";
    public static final String PLATFORM_EVENT_LOG_DUMP_DIR = "/";
    public static final String SMA_DUMP_DIR = "/";
    public static final String POWER_SUB_SYSTEM_DUMP_DIR = "/";
    public static final String MOUNT_COMMAND = "/bin/mount ";
    public static final String FSPDUMP = "FSPDUMP";
    public static final String SYSDUMP = "SYSDUMP";
    public static final String LOGDUMP = "LOGDUMP";
    public static final String SMADUMP = "SMADUMP";
    public static final String PWRDUMP = "PWRDUMP";
    public boolean mInvalidateDump = true;

    private FspFileOpCmds() {
    }

    static FspFileOpCmds getInstance() {
        if (mInst == null) {
            mInst = new FspFileOpCmds();
        }
        return mInst;
    }

    byte[] readFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, long l3) throws PIHscServerException, PIHscCmdMgrException {
        return this.readFileCmd(fSPCmdMgr, n, l, l2, l3, null);
    }

    byte[] readFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, long l3, String string) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        boolean bl = false;
        byte[] byArray = new byte[]{};
        long l4 = this.getMaxCommandSize(fSPCmdMgr);
        System.out.println("maxSize = " + l4);
        long l5 = l4 - 50L;
        int n2 = 1;
        long l6 = l3 % l5;
        n2 = l3 > l5 && l6 != 0L ? (int)(l3 / l5 + 1L) : (l6 == 0L ? (int)(l3 / l5) : 1);
        long l7 = l2;
        for (int i = 0; i < n2; ++i) {
            long l8 = 0L;
            l8 = i != n2 - 1 || l6 == 0L ? l5 : l6;
            try {
                hashtable = fSPCmdMgr.doFSPCommand(READ_FILE, new String[]{Integer.toString(n), Long.toString(l), Long.toString(l7), Long.toString(l8)}, string);
                byte[] byArray2 = (byte[])hashtable.get(DATA);
                byArray = ByteUtilities.byteCat(byArray, byArray2);
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                pIHscCmdMgrException.printStackTrace();
                bl = true;
            }
            l7 += l8;
        }
        if (bl) {
            return null;
        }
        return byArray;
    }

    long writeFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, long l3, byte[] byArray) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        boolean bl = false;
        long l4 = 0L;
        System.out.println("write file ---> ");
        System.out.println("fileID = " + n);
        System.out.println("subID = " + l);
        System.out.println("startOffset = " + l2);
        System.out.println("length = " + l3);
        if (byArray != null) {
            System.out.println("data.length = " + byArray.length);
        }
        long l5 = this.getMaxCommandSize(fSPCmdMgr);
        System.out.println("maxSize = " + l5);
        long l6 = l5 - 50L;
        int n2 = 1;
        long l7 = l3 % l6;
        n2 = l3 > l6 && l7 != 0L ? (int)(l3 / l6 + 1L) : (l7 == 0L ? (int)(l3 / l6) : 1);
        long l8 = l2;
        for (int i = 0; i < n2; ++i) {
            long l9 = 0L;
            l9 = i != n2 - 1 || l7 == 0L ? l6 : l7;
            System.out.println("offset = " + l8);
            System.out.println("dataLen = " + l9);
            byte[] byArray2 = new byte[(int)l9];
            System.arraycopy(byArray, (int)(l8 - l2), byArray2, 0, (int)l9);
            String string = ByteUtilities.toHexString(byArray2);
            System.out.println("hexstring.length = " + string.length());
            try {
                hashtable = fSPCmdMgr.doFSPCommand(WRITE_FILE, new String[]{Integer.toString(n), Long.toString(l), Long.toString(l8), Long.toString(l9), string});
                l4 += ((UnsignedInt32)hashtable.get(LENGTH_WRITTEN)).longValue();
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                bl = true;
            }
            l8 += l9;
        }
        if (bl) {
            return -1L;
        }
        return l4;
    }

    long getFileSize(FSPCmdMgr fSPCmdMgr, int n, long l) throws PIHscServerException, PIHscCmdMgrException {
        Object var5_4 = null;
        boolean bl = false;
        Vector vector = FspFileInfo.getFileInstanceList(fSPCmdMgr, n, l);
        FspFileInfo fspFileInfo = null;
        if (null != vector && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FspFileInfo fspFileInfo2 = (FspFileInfo)enumeration.nextElement();
                if (fspFileInfo2.getSubId() != l) continue;
                fspFileInfo = fspFileInfo2;
                break;
            }
        }
        if (null != fspFileInfo) {
            return fspFileInfo.getFileSize();
        }
        return 0L;
    }

    void acknowledgeDumpCmd(FSPCmdMgr fSPCmdMgr, int n, long l, String string) throws PIHscServerException {
        Hashtable hashtable = null;
        int n2 = 1;
        try {
            String[] stringArray = new String[]{Integer.toString(n), Long.toString(l)};
            if ("PRIMARY".equals(string)) {
                this.debug("calling acknowledgeDump doFSPCommand to CEC FSP");
                hashtable = fSPCmdMgr.doFSPCommand(ACKNOWLEDGE_PLATFORM_DUMP, stringArray, 0);
            } else if ("SIDE_A".equals(string) || "SIDE_B".equals(string)) {
                this.debug("calling acknowledgeDump doFSPCommand to BPC FSP");
                hashtable = fSPCmdMgr.doFSPCommand(ACKNOWLEDGE_PLATFORM_DUMP, stringArray, 0, null, n2, string);
            }
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
        }
    }

    void closeFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2) throws PIHscServerException {
        Hashtable hashtable = null;
        try {
            hashtable = fSPCmdMgr.doFSPCommand(CLOSE_FILE, new String[]{Integer.toString(n), Long.toString(l), Long.toString(l2)});
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
        }
    }

    void closeBpcFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, String string) throws PIHscServerException {
        Hashtable hashtable = null;
        try {
            int n2 = 1;
            String[] stringArray = new String[]{Integer.toString(n), Long.toString(l), Long.toString(l2)};
            hashtable = fSPCmdMgr.doFSPCommand(CLOSE_FILE, stringArray, 0, null, n2, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
        }
    }

    void closeFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, String string) throws PIHscServerException {
        Hashtable hashtable = null;
        try {
            hashtable = fSPCmdMgr.doFSPCommand(CLOSE_FILE, new String[]{Integer.toString(n), Long.toString(l), Long.toString(l2)}, string);
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
        }
    }

    private String getDumpDirectory(int n) {
        String string = "";
        if (n == 1) {
            string = "/dump/";
        }
        if (n == 8) {
            string = "/dump/";
        }
        if (n == 17) {
            string = "/dump/";
        }
        if (n == 3) {
            string = "/dump/";
        }
        if (n == 21) {
            string = "/dump/";
        }
        return string;
    }

    private boolean isDumpPartitionExists() throws PIHscServerException {
        File file = new File(MOUNT_PARTITION);
        return file.exists();
    }

    private boolean isDumpDirectoryExists(String string) throws PIHscServerException {
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    private boolean createDumpDirectory(String string) throws PIHscServerException {
        File file = new File(string);
        try {
            return file.mkdir();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean mountDumpPartition() throws PIHscServerException {
        this.debug("Mounting dump partition");
        boolean bl = false;
        try {
            String string = "/bin/mount /dump";
            this.debug("dump cmd is : " + string);
            Process process = Runtime.getRuntime().exec(string);
            bl = this.isDumpPartitionExists();
            this.debug("isDumpPartitionExists() -> " + bl);
        }
        catch (Throwable throwable) {
            throw new PIHscServerException("0608", throwable);
        }
        return bl;
    }

    private void debug(String string) {
        System.out.println("DUMP." + string);
    }

    private void writeDumpErrorLog(long l, long l2, int n, String string, String string2, int n2) {
        try {
            this.debug("in writeDumpErrorLog()");
            String string3 = "dumperror.log";
            File file = new File("/dump/" + string3);
            if (!file.exists()) {
                file.createNewFile();
            }
            String string4 = "0x0058 (Invalid file offset)";
            String string5 = "Truncated platform dump";
            if (47 == n2) {
                string4 = "0x002F (Dump Truncated)";
            } else if (88 == n2) {
                string5 = string5 + " - An End Of File was encountered before reading the prescribed number of bytes of the platform dump file.";
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            this.debug("dump error log is " + file.getName());
            String string6 = "\nDate & Time        : " + DateFormat.getDateTimeInstance(3, 3).format(new Date());
            string6 = string6 + "\nFSP name           : " + string2;
            string6 = string6 + "\nPLID               : 1";
            string6 = string6 + "\nReason             : " + string5;
            string6 = string6 + "\nExpected file size : " + l + " bytes";
            string6 = string6 + "\nFile read size     : " + l2 + " bytes";
            string6 = string6 + "\nError code         : " + string4;
            string6 = string6 + "\nFile name          : " + string;
            string6 = string6 + "\n--------------------------------------------------------------------------------------";
            this.debug("error log  entry is " + string6);
            this.debug("logging an error...");
            if (printWriter != null) {
                printWriter.println(string6);
                printWriter.flush();
                printWriter.close();
                this.debug("error log is done.");
            }
        }
        catch (IOException iOException) {
            this.debug("IOException in writeDumpErrorLog : " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    void setInvalidateDumpFlag(boolean bl) {
        this.mInvalidateDump = bl;
        this.debug("setInvalidateDumpFlag=" + this.mInvalidateDump);
    }

    boolean canInvalidateDump() {
        return this.mInvalidateDump;
    }

    File readDumpFileCmd(FSPCmdMgr fSPCmdMgr, int n, long l, long l2, long l3, String string) throws PIHscServerException, PIHscCmdMgrException {
        Object object;
        String[] stringArray;
        this.setInvalidateDumpFlag(true);
        Hashtable hashtable = null;
        boolean bl = false;
        boolean bl2 = false;
        long l4 = 65536L;
        long l5 = l4 - 50L;
        int n2 = 1;
        File file = null;
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        int n3 = 0;
        String string2 = this.getDumpDirectory(n);
        this.debug("Dump file directory : " + string2);
        this.debug("check for DumpPartition");
        if (!this.isDumpPartitionExists()) {
            this.debug("calling mountDumpPartition");
            this.mountDumpPartition();
        }
        this.debug("check for dump directory");
        if (!this.isDumpDirectoryExists(string2 + "/")) {
            this.debug("creating a dump directory");
            this.createDumpDirectory(string2 + "/");
        }
        try {
            file = new File(string2 + "/" + Long.toString(n) + Long.toString(l) + Long.toString(l2) + Long.toString(l3));
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.debug("tmp file created : " + file.getName());
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while (l2 < l3) {
                try {
                    this.debug("Start reading from " + l2 + " (" + Long.toHexString(l2) + ") to " + (l2 + l5) + " (" + Long.toHexString(l2 + l5) + ") ");
                    stringArray = new String[]{Integer.toString(n), Long.toString(l), Long.toString(l2), Long.toString(l5)};
                    if ("PRIMARY".equals(string)) {
                        this.debug("calling ReadFile doFSPCommand to CEC FSP");
                        hashtable = fSPCmdMgr.doFSPCommand(READ_FILE, stringArray, 0);
                    } else if ("SIDE_A".equals(string) || "SIDE_B".equals(string)) {
                        this.debug("calling ReadFile doFSPCommand to BPC FSP");
                        hashtable = fSPCmdMgr.doFSPCommand(READ_FILE, stringArray, 0, null, n2, string);
                    }
                    object = (byte[])hashtable.get(DATA);
                    bufferedOutputStream.write((byte[])object);
                    this.debug("ReadFile.Read " + (l2 + (long)((Object)object).length) + " of " + l3 + " bytes");
                    l2 += (long)((Object)object).length;
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    n3 = pIHscCmdMgrException.getStatus();
                    if (n3 == 88) {
                        this.debug("0x0058 INVALID_FILE_OFFSET");
                        this.debug("Premature EOF dump file condition");
                        bl2 = true;
                        bl = false;
                        this.setInvalidateDumpFlag(true);
                        break;
                    }
                    if (n3 == 47) {
                        this.debug("0x002F DUMP TRUNCATED");
                        bl2 = true;
                        bl = false;
                        this.setInvalidateDumpFlag(false);
                        break;
                    }
                    bl = true;
                    bl2 = false;
                    break;
                }
            }
            bufferedOutputStream.flush();
            fileOutputStream.flush();
            fileOutputStream.close();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            this.debug("IOException : " + iOException.toString());
            bl = true;
        }
        if (bl) {
            return null;
        }
        try {
            stringArray = new FileInputStream(file);
            object = new BufferedInputStream((InputStream)stringArray);
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[39];
            ((BufferedInputStream)object).read(byArray, 0, 8);
            String string3 = "";
            String string4 = "";
            string3 = new String(byArray);
            if (DUMP_ENTRY_HEADER.equals(string3.trim())) {
                ((BufferedInputStream)object).skip(16L);
            }
            ((BufferedInputStream)object).read(byArray2, 0, 39);
            string4 = new String(byArray2);
            this.debug("file name is : " + string4);
            ((BufferedInputStream)object).close();
            stringArray.close();
            File file2 = null;
            file2 = !bl2 ? new File(string2 + "/" + string4) : new File(string2 + "/" + string4 + ".PARTIAL");
            if (file.renameTo(file2)) {
                this.debug("Rename Success. The new file name is : " + file2.getName());
                if (bl2) {
                    this.writeDumpErrorLog(l3, l2, n3, file2.getName(), fSPCmdMgr.getSysName(), n3);
                }
                return file2;
            }
            this.debug("Rename Failure");
            return file;
        }
        catch (IOException iOException) {
            this.debug("Dump file processing exception : " + iOException.toString());
            iOException.printStackTrace();
            return null;
        }
    }

    private int getMaxCommandSize(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        FspCecInterfaceImplLimits fspCecInterfaceImplLimits = fSPCmdMgr.getInterfaceLimits();
        return fspCecInterfaceImplLimits.getMaxCommandSize().intValue();
    }
}

